/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class PurgatoryModifier
extends Modifier
implements TooltipModifierHook,
BreakSpeedModifierHook,
MeleeDamageModifierHook,
ConditionalStatModifierHook {
    public boolean isNetherDimension(Entity entity) {
        return entity != null && this.isNetherDimension(entity.f_19853_);
    }

    public boolean isNetherDimension(Level level) {
        return level.m_46472_().equals((Object)Level.f_46429_);
    }

    public float getMeleeDamage(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        if (context.getLivingTarget() != null) {
            LivingEntity target = context.getLivingTarget();
            if (this.isNetherDimension(target.f_19853_)) {
                return damage * (1.0f + (float)modifier.getLevel() * 0.08f);
            }
        }
        return damage;
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.TOOLTIP, ModifierHooks.MELEE_DAMAGE, ModifierHooks.CONDITIONAL_STAT);
    }

    public void onBreakSpeed(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull PlayerEvent.BreakSpeed event, @Nonnull Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (this.isNetherDimension((Entity)event.getEntity())) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f + (float)modifier.getLevel() * 0.08f));
        }
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        int level = modifier.getLevel();
        if (this.isNetherDimension((Entity)living) && stat == ToolStats.DRAW_SPEED) {
            return baseValue * 1.08f * (float)level;
        }
        return baseValue;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (player != null && this.isNetherDimension((Entity)player)) {
            TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.modifier.purgatory.attack_damage"), (double)(0.08f * (float)modifier.getLevel()), tooltip);
            TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.modifier.purgatory.mining_speed"), (double)(0.08f * (float)modifier.getLevel()), tooltip);
        }
    }
}

